/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeChunkManager;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.entity.data.role.IJobChunkLoader;
import noppes.npcs.controllers.ChunkController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobChunkLoader
extends JobInterface
implements IJobChunkLoader {
    private List<ChunkPos> chunks = new ArrayList<ChunkPos>();
    private long playerLastSeen = 0L;
    private int ticks = 20;

    public JobChunkLoader(EntityNPCInterface npc) {
        super(npc);
        this.type = JobType.CHUNK_LOADER;
    }

    @Override
    public boolean isWorking() {
        return !this.chunks.isEmpty() || ChunkController.instance.hasToNpc(this.npc);
    }

    @Override
    public boolean aiContinueExecute() {
        return false;
    }

    @Override
    public boolean aiShouldExecute() {
        --this.ticks;
        if (this.ticks > 0) {
            return false;
        }
        this.ticks = 20;
        List players = new ArrayList();
        try {
            players = this.npc.field_70170_p.func_72872_a(EntityPlayer.class, this.npc.func_174813_aQ().func_72314_b(48.0, 48.0, 48.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!players.isEmpty()) {
            this.playerLastSeen = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() > this.playerLastSeen + 600000L) {
            ChunkController.instance.deleteNPC(this.npc);
            this.chunks.clear();
            return false;
        }
        ForgeChunkManager.Ticket ticket = ChunkController.instance.getTicket(this.npc);
        if (ticket == null) {
            return false;
        }
        ArrayList<ChunkPos> list = new ArrayList<ChunkPos>();
        int x = MathHelper.func_76128_c((double)this.npc.field_70165_t);
        int z = MathHelper.func_76128_c((double)this.npc.field_70161_v);
        for (int u = -1; u < 2; ++u) {
            for (int v = -1; v < 2; ++v) {
                list.add(new ChunkPos(x + u, z + v));
            }
        }
        for (ChunkPos chunk : list) {
            if (!this.chunks.contains(chunk)) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
                continue;
            }
            this.chunks.remove(chunk);
        }
        for (ChunkPos chunk : this.chunks) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
        }
        this.chunks = list;
        return false;
    }

    @Override
    public void load(NBTTagCompound compound) {
        super.load(compound);
        this.type = JobType.CHUNK_LOADER;
        this.playerLastSeen = compound.func_74763_f("ChunkPlayerLastSeen");
    }

    @Override
    public void reset() {
        ChunkController.instance.deleteNPC(this.npc);
        this.chunks.clear();
        this.playerLastSeen = 0L;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        super.save(compound);
        compound.func_74772_a("ChunkPlayerLastSeen", this.playerLastSeen);
        return compound;
    }
}

